# Capitula Campaign Configuration - WordPress Plugin

## Overview

The **Capitula Campaign Configuration** plugin automatically integrates the Capitula affiliate tracking system with WordPress websites. It's designed specifically for AC (Commissioner) clients to easily embed tracking codes and monitor conversions without manual code modifications.

## Plugin Features

### 🌐 **Automatic CDN Integration**
- Automatically injects Capitula CDN scripts into website headers
- Fixed CDN URL: `https://demo.capitula.co.uk`
- Cross-domain compatibility with fallback options
- Dynamic version parameters using `Date.now()`

### 🛒 **WooCommerce Integration**
- Automatic detection of WooCommerce installations
- Order conversion tracking on thank-you pages
- Wraps transaction data with Capitula tags:
  - `<capitula_pay>$total_amount</capitula_pay>`
  - `<capitula_trans>transaction_id</capitula_trans>`
- Smart retry mechanism for CDN loading

### 📝 **Contact Form Support**
- **Contact Form 7** integration
- **Gravity Forms** integration
- **Ninja Forms** integration
- Automatically wraps email addresses with `<capitula_email>` tags
- Works on form submission success pages

### 👤 **User Registration Tracking**
- WordPress user registration detection
- Email wrapping with `<capitula_email>` tags
- Session-based tracking for registration flows
- Automatic cleanup of tracking data

### ⚙️ **Professional Admin Interface**
- Custom sidebar menu with Capitula logo
- Clean, branded admin pages
- Real-time plugin status monitoring
- System compatibility checker
- CDN code preview and debugging tools

## Installation

### Manual Installation
1. Upload the plugin folder to `/wp-content/plugins/capitula-campaign-configuration/`
2. Activate the plugin through the WordPress admin
3. Configure settings via **Capitula** menu in WordPress admin sidebar

### File Structure
```
capitula-campaign-configuration/
├── capitula-campaign-configuration.php (Main plugin file)
├── logo-black.png (Capitula logo)
└── README.md (This documentation)
```

## Configuration

### Admin Menu Location
- **WordPress Admin Sidebar** > **Capitula** (with custom logo icon)
- **Two main pages:**
  - **Settings** - Plugin configuration
  - **Status & Debug** - System information and troubleshooting

### Available Settings

#### 1. Cross-Domain Fallback
- **Purpose:** Prevents browser blocking of cross-site scripts
- **Default:** Disabled (uses original method)
- **When Enabled:** Adds `defer` attribute to script tags for cross-domain compatibility

#### 2. WooCommerce Integration
- **Purpose:** Enable/disable order conversion tracking
- **Default:** Enabled
- **Requires:** WooCommerce plugin installation

#### 3. Contact Form Integration
- **Purpose:** Enable/disable form submission tracking
- **Default:** Enabled
- **Supports:** Contact Form 7, Gravity Forms, Ninja Forms

#### 4. User Registration Tracking
- **Purpose:** Enable/disable user registration conversion tracking
- **Default:** Enabled
- **Tracks:** WordPress user registrations

## Technical Implementation

### CDN Script Injection

#### Standard Mode (Cross-Domain Fallback Disabled)
```html
<script>
document.write("<script type='text/javascript' src='https://demo.capitula.co.uk/assets/js/capitula_cdn.js?v=" + Date.now() + "'><\/script>");
</script>
<script type="text/javascript">
if(typeof jQuery == 'undefined'){
    document.write('<script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></'+'script>');
}
</script>
```

#### Cross-Domain Safe Mode (Cross-Domain Fallback Enabled)
```html
<script>
document.write("<script type='text/javascript' src='https://demo.capitula.co.uk/assets/js/capitula_cdn.js?v=" + Date.now() + "' defer><\/script>");
</script>
<script type="text/javascript">
if (typeof jQuery == 'undefined') {
    document.write("<script type='text/javascript' src='https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js' defer><\/script>");
}
</script>
```

### Conversion Tracking Implementation

#### WooCommerce Orders
- **Hook:** `woocommerce_thankyou`
- **Data Captured:**
  - Order total amount
  - Transaction/Order ID
- **Tags Generated:**
  ```html
  <div style="display:none;">
  <capitula_pay>19.99</capitula_pay>
  <capitula_trans>12345</capitula_trans>
  </div>
  ```

#### Contact Forms
- **Contact Form 7:** `wpcf7_mail_sent` hook
- **Gravity Forms:** `gform_after_submission` hook
- **Ninja Forms:** `ninja_forms_after_submission` hook
- **Email Detection:** Automatic field type detection
- **Tag Generated:**
  ```html
  <div style="display:none;">
  <capitula_email>user@example.com</capitula_email>
  </div>
  ```

#### User Registrations
- **Hooks:** `user_register` and `wp_login`
- **Method:** Transient-based email storage and retrieval
- **Duration:** 5-minute cleanup window
- **Tag Generated:**
  ```html
  <div style="display:none;">
  <capitula_email>newuser@example.com</capitula_email>
  </div>
  ```

## Branding & Design

### Visual Identity
- **Brand Color:** `#25caf1` (Capitula blue)
- **Logo:** Custom Capitula logo in admin interface
- **Styling:** WordPress admin theme compliant
- **Icons:** Custom dashicons with brand color

### Admin Interface Features
- **Responsive Design:** Works on desktop and mobile admin
- **Status Indicators:** Color-coded plugin compatibility
- **Live Preview:** Shows actual CDN code output
- **Professional Layout:** Split-panel design with sidebar status

## Plugin Architecture

### Main Class: `CapitulaCampaignConfig`
- **Pattern:** Singleton design pattern
- **Hooks:** WordPress action and filter integration
- **Methods:** Modular functionality for each feature

### Key WordPress Hooks Used
- `init` - Plugin initialization
- `wp_head` - CDN script injection
- `admin_menu` - Admin interface creation
- `admin_head` - Custom CSS injection
- `woocommerce_thankyou` - Order tracking
- Contact form specific hooks for each supported plugin

### Database Options
- `capitula_enable_fallback` - Cross-domain fallback setting
- `capitula_enable_woocommerce` - WooCommerce integration toggle
- `capitula_enable_contact_forms` - Contact form integration toggle
- `capitula_enable_registration` - Registration tracking toggle

## Browser Compatibility

### Cross-Domain Handling
- **Issue:** Modern browsers block cross-site `document.write` scripts
- **Solution:** Optional `defer` attribute fallback
- **Browsers Affected:** Chrome, Safari, Firefox (latest versions)
- **Warning Prevented:** Parser-blocking cross-site script warnings

### Supported Browsers
- Chrome 60+
- Firefox 55+
- Safari 10+
- Edge 79+
- Internet Explorer 11 (limited support)

## Troubleshooting

### Common Issues

#### 1. Console Warnings about Cross-Site Scripts
- **Solution:** Enable "Cross-Domain Fallback" in plugin settings
- **Location:** WordPress Admin > Capitula > Settings
- **Effect:** Adds `defer` attribute to prevent browser blocking

#### 2. WooCommerce Tracking Not Working
- **Check:** WooCommerce plugin is installed and active
- **Verify:** WooCommerce integration is enabled in Capitula settings
- **Test:** Place a test order and check thank-you page source

#### 3. Contact Form Tracking Not Working
- **Supported Forms:** Contact Form 7, Gravity Forms, Ninja Forms
- **Check:** Form plugin is active and integration is enabled
- **Verify:** Email field exists and is properly configured

#### 4. CDN Script Not Loading
- **Check:** Network connectivity to `demo.capitula.co.uk`
- **Enable:** Cross-domain fallback if needed
- **View:** Status & Debug page for code preview

### Debug Information
- **Admin Page:** WordPress Admin > Capitula > Status & Debug
- **Shows:**
  - Plugin version and compatibility
  - WordPress and plugin versions
  - Current configuration settings
  - Live CDN code preview

## Development & Maintenance

### Plugin Version: 1.0.0
- **WordPress Compatibility:** 5.0+
- **PHP Compatibility:** 7.4+
- **Testing Environment:** WordPress 6.x

### File Permissions
- Plugin files should be readable by web server
- Logo file (`logo-black.png`) must be accessible via HTTP

### Updates & Support
- Plugin updates handled manually
- Configuration preserved during updates
- Automatic cleanup on deactivation

## Security Considerations

### Data Handling
- **Email Data:** Temporarily stored in WordPress transients (5-minute expiry)
- **No Persistent Storage:** No sensitive data stored permanently
- **Sanitization:** All outputs properly escaped and sanitized

### Cross-Site Scripting (XSS) Prevention
- All user inputs sanitized using WordPress functions
- HTML output properly escaped
- Admin capabilities checked (`manage_options`)

## Integration Guide for AC Clients

### Step 1: Plugin Installation
1. Download and install the plugin
2. Activate via WordPress admin
3. Look for "Capitula" in admin sidebar

### Step 2: Basic Configuration
1. Navigate to **Capitula > Settings**
2. Enable **Cross-Domain Fallback** (recommended)
3. Configure tracking features as needed
4. Save settings

### Step 3: WooCommerce Setup (if applicable)
1. Ensure WooCommerce is installed and active
2. Enable **WooCommerce Integration** in Capitula settings
3. Test with a sample order

### Step 4: Form Integration (if applicable)
1. Install supported form plugins (Contact Form 7, Gravity Forms, or Ninja Forms)
2. Enable **Contact Form Integration** in Capitula settings
3. Ensure forms have email fields
4. Test form submissions

### Step 5: Verification
1. Visit **Capitula > Status & Debug** to verify setup
2. Check website source code for CDN scripts
3. Test conversions and verify tracking

## Support & Documentation

### Plugin Status Information
- **Real-time compatibility checking**
- **System requirements verification**
- **Configuration validation**
- **Live code preview**

### Best Practices
1. **Always enable cross-domain fallback** for better browser compatibility
2. **Test thoroughly** after installation on staging environment
3. **Monitor Status & Debug page** for any issues
4. **Keep WordPress and plugins updated** for security

---

## Plugin Information

- **Plugin Name:** Capitula Campaign Configuration
- **Version:** 1.0.0
- **Author:** Capitula Team
- **License:** GPL v2 or later
- **WordPress Required:** 5.0+
- **PHP Required:** 7.4+

**Documentation Last Updated:** January 27, 2025